

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of AND16 is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN2_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN3_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN4_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN5_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN6_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN7_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN8_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN9_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN10_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN11_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN12_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN13_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN14_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN15_ipd	 : STD_LOGIC := 'X';
   SIGNAL IN16_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (IN2_ipd, IN2, VitalExtendToFillDelay(tipd_IN2));
   VitalPropagateWireDelay (IN3_ipd, IN3, VitalExtendToFillDelay(tipd_IN3));
   VitalPropagateWireDelay (IN4_ipd, IN4, VitalExtendToFillDelay(tipd_IN4));
   VitalPropagateWireDelay (IN5_ipd, IN5, VitalExtendToFillDelay(tipd_IN5));
   VitalPropagateWireDelay (IN6_ipd, IN6, VitalExtendToFillDelay(tipd_IN6));
   VitalPropagateWireDelay (IN7_ipd, IN7, VitalExtendToFillDelay(tipd_IN7));
   VitalPropagateWireDelay (IN8_ipd, IN8, VitalExtendToFillDelay(tipd_IN8));
   VitalPropagateWireDelay (IN9_ipd, IN9, VitalExtendToFillDelay(tipd_IN9));
   VitalPropagateWireDelay (IN10_ipd, IN10, VitalExtendToFillDelay(tipd_IN10));
   VitalPropagateWireDelay (IN11_ipd, IN11, VitalExtendToFillDelay(tipd_IN11));
   VitalPropagateWireDelay (IN12_ipd, IN12, VitalExtendToFillDelay(tipd_IN12));
   VitalPropagateWireDelay (IN13_ipd, IN13, VitalExtendToFillDelay(tipd_IN13));
   VitalPropagateWireDelay (IN14_ipd, IN14, VitalExtendToFillDelay(tipd_IN14));
   VitalPropagateWireDelay (IN15_ipd, IN15, VitalExtendToFillDelay(tipd_IN15));
   VitalPropagateWireDelay (IN16_ipd, IN16, VitalExtendToFillDelay(tipd_IN16));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, IN2_ipd, IN3_ipd, IN4_ipd, IN5_ipd, IN6_ipd, IN7_ipd, IN8_ipd, IN9_ipd, IN10_ipd, IN11_ipd, IN12_ipd, IN13_ipd, IN14_ipd, IN15_ipd, IN16_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd :=
       (IN2_ipd) AND (IN1_ipd) AND (IN3_ipd) AND (IN4_ipd) AND (IN5_ipd) AND
         (IN6_ipd) AND (IN7_ipd) AND (IN8_ipd) AND (IN9_ipd) AND (IN10_ipd)
         AND (IN11_ipd) AND (IN12_ipd) AND (IN13_ipd) AND (IN14_ipd) AND
         (IN15_ipd) AND (IN16_ipd);

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (IN2_ipd'last_event, VitalExtendToFillDelay(tpd_IN2_Y), TRUE),
                 2 => (IN3_ipd'last_event, VitalExtendToFillDelay(tpd_IN3_Y), TRUE),
                 3 => (IN4_ipd'last_event, VitalExtendToFillDelay(tpd_IN4_Y), TRUE),
                 4 => (IN5_ipd'last_event, VitalExtendToFillDelay(tpd_IN5_Y), TRUE),
                 5 => (IN6_ipd'last_event, VitalExtendToFillDelay(tpd_IN6_Y), TRUE),
                 6 => (IN7_ipd'last_event, VitalExtendToFillDelay(tpd_IN7_Y), TRUE),
                 7 => (IN8_ipd'last_event, VitalExtendToFillDelay(tpd_IN8_Y), TRUE),
                 8 => (IN9_ipd'last_event, VitalExtendToFillDelay(tpd_IN9_Y), TRUE),
                 9 => (IN10_ipd'last_event, VitalExtendToFillDelay(tpd_IN10_Y), TRUE),
                 10 => (IN11_ipd'last_event, VitalExtendToFillDelay(tpd_IN11_Y), TRUE),
                 11 => (IN12_ipd'last_event, VitalExtendToFillDelay(tpd_IN12_Y), TRUE),
                 12 => (IN13_ipd'last_event, VitalExtendToFillDelay(tpd_IN13_Y), TRUE),
                 13 => (IN14_ipd'last_event, VitalExtendToFillDelay(tpd_IN14_Y), TRUE),
                 14 => (IN15_ipd'last_event, VitalExtendToFillDelay(tpd_IN15_Y), TRUE),
                 15 => (IN16_ipd'last_event, VitalExtendToFillDelay(tpd_IN16_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;